/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.init;

import com.mysticsbiomes.client.entity.model.StrawberryCowModel;
import com.mysticsbiomes.client.entity.renderer.BoatRenderer;
import com.mysticsbiomes.client.entity.renderer.RedPandaRenderer;
import com.mysticsbiomes.client.entity.renderer.StrawberryCowRenderer;
import com.mysticsbiomes.common.entity.animal.RedPanda;
import com.mysticsbiomes.common.entity.animal.StrawberryCow;
import com.mysticsbiomes.common.entity.vehicle.Boat;
import com.mysticsbiomes.common.entity.vehicle.ChestBoat;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="mysticsbiomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MysticEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"mysticsbiomes");
    public static final RegistryObject<EntityType<StrawberryCow>> STRAWBERRY_COW = ENTITIES.register("strawberry_cow", () -> EntityType.Builder.m_20704_(StrawberryCow::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_("mysticsbiomes:strawberry_cow"));
    public static final RegistryObject<EntityType<RedPanda>> RED_PANDA = ENTITIES.register("red_panda", () -> EntityType.Builder.m_20704_(RedPanda::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_("mysticsbiomes:red_panda"));
    public static final RegistryObject<EntityType<Boat>> BOAT = ENTITIES.register("boat", () -> EntityType.Builder.m_20704_(Boat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("mysticsbiomes:boat"));
    public static final RegistryObject<EntityType<ChestBoat>> CHEST_BOAT = ENTITIES.register("chest_boat", () -> EntityType.Builder.m_20704_(ChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("mysticsbiomes:chest_boat"));

    @SubscribeEvent
    public static void registerEntities(EntityAttributeCreationEvent event) {
        event.put((EntityType)STRAWBERRY_COW.get(), StrawberryCow.createAttributes().m_22265_());
        event.put((EntityType)RED_PANDA.get(), RedPanda.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerEntitySpawns(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)STRAWBERRY_COW.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)RED_PANDA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    @Mod.EventBusSubscriber(modid="mysticsbiomes", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(StrawberryCowModel.LAYER, StrawberryCowModel::createBodyLayer);
            for (Boat.Type type : Boat.Type.values()) {
                event.registerLayerDefinition(BoatRenderer.createBoatModelName(type), () -> BoatModel.m_233347_((boolean)false));
                event.registerLayerDefinition(BoatRenderer.createChestBoatModelName(type), () -> BoatModel.m_233347_((boolean)true));
            }
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)STRAWBERRY_COW.get(), StrawberryCowRenderer::new);
            event.registerEntityRenderer((EntityType)RED_PANDA.get(), RedPandaRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)BOAT.get()), context -> new BoatRenderer(context, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)CHEST_BOAT.get()), context -> new BoatRenderer(context, true));
        }
    }
}

